<?php

header("X-Robots-Tag: noindex, nofollow", true);

// fetch_member_loan.php

// Database connection
include("include/connection.php");

$conn = new mysqli($host, $user, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Retrieve the Member No from AJAX request
$memberNo = $_POST['memberNo'];



// Prepare the response array
$response = ['success' => false];

// Query to get the member's name and active loan details
$sql = "
    SELECT m.memberName, l.loanNo, l.LoanBalance 
    FROM member m 
    LEFT JOIN loan l ON m.memberNo = l.memberNo
    WHERE m.memberNo = ? AND l.LoanBalance > 0
    LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $memberNo);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // If the member has an active loan
    $row = $result->fetch_assoc();
    $response['success'] = true;
    $response['memberName'] = $row['memberName'];
    $response['loanNo'] = $row['loanNo'];
    $response['LoanBalance'] = $row['LoanBalance'];
} else {
    // If no active loan is found, or loan amount is zero
    $response['message'] = "No active loans found for this member.";
}

// Send the response back to the frontend as JSON
echo json_encode($response);

$stmt->close();
$conn->close();
?>
